definition module wstate


import	windowhandle


/*	The WindowHandle` data type.
	This type is a subtype of the WindowHandle data type. The WindowHandle` data type takes the projection of those fields of 
	the (WindowHandle ls ps) data type that do not depend on the type variables {ls,ps}.
*/
::	WindowHandle`
	=	{	whMode`				:: WindowMode					// The window mode (Modal or Modeless)
		,	whKind`				:: WindowKind					// The window kind (Window or Dialog)
		,	whTitle`			:: Title						// The window title
		,	whItemNrs`			:: [Int]						// The list of free system item numbers for all controls
		,	whKeyFocus`			:: KeyFocus						// The item that has the keyboard input focus
		,	whWindowInfo`		:: Maybe WindowInfo				// Additional information about the Window (Nothing for Dialogs)
		,	whItems`			:: [WElementHandle`]			// The window controls
		,	whShow`				:: Bool							// The visibility of the window (True iff visible)
		,	whSelect`			:: Bool							// The WindowSelect==Able (by default True)
		,	whAtts`				:: [WindowAttribute`]			// The window attributes
		,	whDefaultId`		:: Maybe Id						// The Id of the optional default button
		,	whCancelId`			:: Maybe Id						// The Id of the optional cancel  button
		,	whSize`				:: Size							// The exact size of the window
		}
::	WElementHandle`
	=	WItemHandle`			WItemHandle`
	|	WRecursiveHandle`		[WElementHandle`] WRecursiveKind
::	WRecursiveKind
	=	IsWListLSHandle
	|	IsWExtendLSHandle
	|	IsWChangeLSHandle
::	WItemHandle`
	=	{	wItemId`			:: Maybe Id						// If the control has a (ControlId id) attribute, then Just id; Nothing
		,	wItemNr`			:: Int							// The internal nr of this control  (generated from whIds)
		,	wItemKind`			:: ControlKind					// The sort of control
		,	wItemShow`			:: Bool							// The visibility of the control (True iff visible)
		,	wItemSelect`		:: Bool							// The ControlSelectState==Able  (by default True)
		,	wItemInfo`			:: WItemInfo`					// Additional information of the control
		,	wItemAtts`			:: [ControlAttribute`]			// The control attributes
		,	wItems`				:: [WElementHandle`]			// In case of	CompoundControl	: its control elements
																//				Otherwise		: []
		,	wItemPos`			:: !Point						// The exact position of the item
		,	wItemFixedPos`		:: Bool							// The layout of the item is either Fix or relative to a Fix item
		,	wItemSize`			:: Size							// The exact size of the item
		,	wItemPtr`			:: OSWindowPtr					// The ptr to the item (OSNoWindowPtr if no handle)
		}
::	WItemInfo`
	=	RadioInfo`				RadioInfo`						// In case of	RadioControl		: the radio items information
	|	CheckInfo`				CheckInfo`						// In case of	CheckControl		: the check items information
	|	PopUpInfo`				PopUpInfo`						// In case of	PopUpControl		: the pop up information
	|	SliderInfo`				SliderInfo`						// In case of	SliderControl		: the slider information
	|	TextInfo`				TextInfo						// In case of	TextControl			: the text information
	|	EditInfo`				EditInfo						// In case of	EditControl			: the edit text information
	|	ButtonInfo`				ButtonInfo						// In case of	ButtonControl		: the button information
	|	CustomButtonInfo`		CustomButtonInfo				// In case of	CustomButtonControl	: the custom button information
	|	CustomInfo`				CustomInfo						// In case of	CustomControl		: the custom information
	|	CompoundInfo`			CompoundInfo					// In case of	CompoundControl		: the compound control information
	|	NoWItemInfo`											// No additional information
::	RadioInfo`
	=	{	radioItems`			:: [RadioItemInfo`]				// The radio items and their exact position (initially zero)
		,	radioLayout`		:: RowsOrColumns				// The layout of the radio items
		,	radioIndex`			:: Int							// The currently selected radio item (1<=radioIndex<=length radioItems)
		}
::	RadioItemInfo`
	=	{	radioItem`			:: TextLine						// The text of the item
		,	radioItemPos`		:: !Point						// The exact position of the item
		,	radioItemSize`		:: Size							// The exact size of the item
		,	radioItemPtr`		:: OSWindowPtr					// The OSWindowPtr of the item
		}
::	CheckInfo`
	=	{	checkItems`			:: [CheckItemInfo`]				// The check items and their exact position (initially zero)
		,	checkLayout`		:: RowsOrColumns				// The layout of the check items
		}
::	CheckItemInfo`
	=	{	checkItem`			:: (TextLine,MarkState)			// The text and mark of the item
		,	checkItemPos`		:: !Point						// The exact position of the item
		,	checkItemSize`		:: Size							// The exact size of the item
		,	checkItemPtr`		:: OSWindowPtr					// The OSWindowPtr of the item
		}
::	PopUpInfo`
	=	{	popUpInfoItems`		:: [TextLine]					// The pop up items
		,	popUpInfoIndex`		:: Index						// The currently selected pop up item (1<=popUpInfoIndex<=length popUpInfoItems)
		}
::	SliderInfo`
	=	{	sliderInfoDir`		:: Direction					// The direction of the slider
		,	sliderInfoLength`	:: Length						// The length (in pixels) of the slider
		,	sliderInfoState`	:: SliderState					// The current slider state
		}
::	WindowAttribute`
	=	WindowId`			Id
	|	WindowPos`			ItemPos
	|	WindowIndex`		Int
	|	WindowSize`			Size
	|	WindowHMargin`		Int Int
	|	WindowVMargin`		Int Int
	|	WindowItemSpace`	Int Int
	|	WindowOk`			Id
	|	WindowCancel`		Id
	|	WindowHide`
	|	WindowClose`
	|	WindowInit`
	|	WindowSelectState`	SelectState
	|	WindowLook`			Look
	|	WindowViewDomain`	ViewDomain
	|	WindowOrigin`		Point
	|	WindowHScroll`		ScrollFunction
	|	WindowVScroll`		ScrollFunction
	|	WindowMinimumSize`	Size
	|	WindowResize`
	|	WindowActivate`
	|	WindowDeactivate`
	|	WindowMouse`		SelectState
	|	WindowKeyboard`		SelectState
	| 	WindowCursor`		CursorShape
::	ControlAttribute`
	=	ControlId`			Id
	|	ControlPos`			ItemPos
	|	ControlSize`		Size
	|	ControlMinimumSize`	Size
	|	ControlResize`		ControlResizeFunction
	|	ControlSelectState`	SelectState
	|	ControlHide`
	|	ControlFunction`
	|	ControlModsFunction`
	|	ControlMouse`		SelectState
	|	ControlKeyboard`	SelectState
	|	ControlItemSpace`	Int Int
	|	ControlHMargin`		Int Int
	|	ControlVMargin`		Int Int
	|	ControlLook`		Look
	|	ControlViewDomain`	ViewDomain
	|	ControlOrigin`		Point
	|	ControlHScroll`		ScrollFunction
	|	ControlVScroll`		ScrollFunction


//	Retrieving the projection type from several arguments.
retrieveWindowHandle`		::              !u:(WindowStateHandle  .ps)	!*OSToolbox -> (!WindowHandle`,	   !u:WindowStateHandle .ps, !*OSToolbox)
getWindowHandle`			:: !OSWindowPtr !u:(WindowHandle   .ls .ps)	!*OSToolbox -> (!WindowHandle`,	   !u:WindowHandle  .ls .ps, !*OSToolbox)
getWElementHandles`			:: !OSWindowPtr ![WElementHandle   .ls .ps]	!*OSToolbox -> (![WElementHandle`],![WElementHandle .ls .ps],!*OSToolbox)
getWItemHandle`				:: !OSWindowPtr !(WItemHandle      .ls .ps)	!*OSToolbox -> (! WItemHandle`,    ! WItemHandle    .ls .ps, !*OSToolbox)

//	Replacing the projection type to several arguments.
insertWindowHandle`			:: !WindowHandle`		!u:(WindowStateHandle .ps)	-> u:WindowStateHandle .ps
setWindowHandle`			:: !WindowHandle`		!u:(WindowHandle   .ls .ps)	-> u:WindowHandle  .ls .ps
setWElementHandles`			:: ![WElementHandle`]	![WElementHandle   .ls .ps]	-> [WElementHandle .ls .ps]
